#include "stdafx.h"
#include "Skrot.h"
#include <shlwapi.h> // PathRemoveFileSpec

BOOL TworzSkrot(LPCTSTR sciezkaLinku, CParametrySkrotu parametrySkrotu)
{
	CoInitializeEx(NULL, COINIT_MULTITHREADED);

	IShellLink* pISLink;
	if (CoCreateInstance(CLSID_ShellLink,
						NULL,
						CLSCTX_INPROC_SERVER,
						IID_IShellLink,
						(void**) &pISLink) != S_OK) return FALSE;

	IPersistFile* pIPFile;
	pISLink->QueryInterface(IID_IPersistFile,(void**) &pIPFile);

	//przygotowanie parametrow
	if (wcscmp(parametrySkrotu.sciezkaPliku,L"")==0) THROW("Brak nazwy pliku, do ktrego ma zosta utworzony skrt");	
	if (wcscmp(parametrySkrotu.katalogRoboczy,L"")==0) 
	{	
		wcscpy_s(parametrySkrotu.katalogRoboczy, MAX_PATH, parametrySkrotu.sciezkaPliku);
		PathRemoveFileSpecW(parametrySkrotu.katalogRoboczy);//parametrySkrotu.katalogRoboczy.GetBuffer());
	}	
	if (parametrySkrotu.rodzajOkna == 0) parametrySkrotu.rodzajOkna = SW_SHOWNORMAL; 
	//nie dopuszczamy SW_HIDE=0 ze wzgledu na taka domyslna inicjacje
	parametrySkrotu.klawiszSkrotu = toupper(parametrySkrotu.klawiszSkrotu);
	
	//przygotowanie obiektu
	pISLink->SetPath(parametrySkrotu.sciezkaPliku);
	pISLink->SetWorkingDirectory(parametrySkrotu.katalogRoboczy);
	pISLink->SetArguments(parametrySkrotu.argumenty);
	if (parametrySkrotu.opis != L"") pISLink->SetDescription(parametrySkrotu.opis);
	pISLink->SetShowCmd(parametrySkrotu.rodzajOkna);
	if (parametrySkrotu.sciezkaIkony != L"") pISLink->SetIconLocation(parametrySkrotu.sciezkaIkony, parametrySkrotu.numerIkony);
	if (parametrySkrotu.klawiszSkrotu != NULL) pISLink->SetHotkey(((HOTKEYF_ALT | HOTKEYF_CONTROL) << 8) | parametrySkrotu.klawiszSkrotu);
	BOOL wynik = (pIPFile->Save(sciezkaLinku, FALSE) == S_OK);
	
	pISLink->Release();
	CoUninitialize();

	return wynik;
}

BOOL CzytajSkrot(LPCTSTR sciezkaLinku, CParametrySkrotu& parametrySkrotu)
{
	CoInitializeEx(NULL, COINIT_MULTITHREADED);
	IShellLink* pISLink;
	if (CoCreateInstance (CLSID_ShellLink,
		NULL,
		CLSCTX_INPROC_SERVER,
		IID_IShellLink,
		(void**) &pISLink) != S_OK) return FALSE;

	IPersistFile* pIPFile;
	pISLink->QueryInterface(IID_IPersistFile,(void**) &pIPFile);

	if (pIPFile->Load(sciezkaLinku, 0) != S_OK)
	{
		pISLink->Release();
		return FALSE;
	}

	TCHAR cstr[MAX_PATH];
	WIN32_FIND_DATA informacjeOPliku; //tu nie wykorzystywane
	pISLink->GetPath(parametrySkrotu.sciezkaPliku, MAX_PATH, &informacjeOPliku, SLGP_UNCPRIORITY);

	pISLink->GetWorkingDirectory(parametrySkrotu.katalogRoboczy , MAX_PATH);

	pISLink->GetArguments(cstr, MAX_PATH);
	wcscpy_s(parametrySkrotu.argumenty,260,cstr);

	pISLink->GetDescription(cstr, MAX_PATH);
	wcscpy_s(parametrySkrotu.opis,260,cstr);

	pISLink->GetShowCmd(&(parametrySkrotu.rodzajOkna));

	pISLink->GetIconLocation(parametrySkrotu.sciezkaIkony, MAX_PATH, &(parametrySkrotu.numerIkony));

	WORD klawiszSkrotu;
	pISLink->GetHotkey(&klawiszSkrotu);
	parametrySkrotu.klawiszSkrotu = (klawiszSkrotu & 255);

	pISLink->Release();

	return TRUE;
}